#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

typedef long long int Z;

Z gcd(Z a, Z b) {
	if(b == 0) return a;
	return gcd(b, a % b);
}

struct R {
	R(Z px, Z py) : x(px), y(py) {
		if(x == 0) {
			y = 1;
			return;
		}
		Z d = gcd(abs(px), abs(py));
		x /= d;
		y /= d;
		if(y < 0) {
			 x = -x;
			 y = -y;
		}
	}
	Z x;
	Z y;
};

R operator+(R a, R b) {
	return R(a.x * b.y + b.x * a.y, a.y * b.y);
}
R operator-(R a, R b) {
	return R(a.x * b.y - b.x * a.y, a.y * b.y);
}

int main() {
	cin.sync_with_stdio(false);
	
	while(true) {
		string S;
		cin >> S;
		if(S == "#") break;
		
		R dir(0, 1);
		R diff(90, 1);
		Z i = S.size();
		while(i != 0) {
			if(S[i - 1] == 'h') {
				if(i == S.size()) {
					dir = R(0, 1);
				} else {
					dir = dir - diff;
				}
				i -= 5;
			} else {
				if(i == S.size()) {
					dir = R(90, 1);
				} else {
					dir = dir + diff;
				}
				i -= 4;
			}
			diff = R(diff.x, 2 * diff.y);
		}
		if(dir.y == 1) {
			cout << dir.x << "\n";
		} else {
			cout << dir.x << "/" << dir.y << "\n";
		}
	}
	
	return 0;
}
